/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.ColorArray;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeLeaf;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.AreaSegment;
import java.awt.Color;

public class AreaChartRow
extends ChartPart {
    private static final double defaultDepth = 0.5;

    public AreaChartRow(ChartProperties properties, DataModel data, int row, Transform3D transform, ColorArray colors) {
        Color color = properties.getColor(row, 0, colors.color(row), 0.0);
        double depth = properties.getProperty("PartDepth", 0.5);
        int dataLength = data.getColumnCount();
        double x = -((double)dataLength - 1.0) / 2.0;
        Transform3D trans = new Transform3D(transform, Transform3D.translate(x, 0.0, 0.0));
        double left = properties.getScaledValue(data, row, 0);
        double right = properties.getScaledValue(data, row, 1);
        AreaSegment segment = new AreaSegment(left, right, depth, trans, color);
        this.add2DPolygons(segment.front());
        SortTreeNode stnPrevious = new SortTreeLeaf(segment.polygons());
        for (int i = 1; i < dataLength - 1; ++i) {
            left = right;
            right = properties.getScaledValue(data, row, i + 1);
            trans = new Transform3D(transform, Transform3D.translate(x += 1.0, 0.0, 0.0));
            segment = new AreaSegment(left, right, depth, trans, color);
            this.add2DPolygons(segment.front());
            SortTreeLeaf stlNew = new SortTreeLeaf(segment.polygons());
            Point3D[] testPoints = new Point3D[]{new Point3D(x, 0.0, 0.0), new Point3D(x, 0.0, 1.0), new Point3D(x, 1.0, 1.0)};
            stnPrevious = new SortTreeInternal(stnPrevious, stlNew, testPoints);
        }
        this.setSortTree(stnPrevious);
    }
}

